% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 24April2012
% Function: Calculates all intermediate results and fees for N calculation
% periods
% Related web page:
% http://finaquant.com/fee-calculator-and-analyzer-for-share-classes-of-mutual-funds-1-calculation/991

function [ResultMatrix,     ...     % stores all intermediate results, a row for each period (year)
    ResultMatrixFields,     ...     % field (column) names of result matrix in a cell array
    EffectiveFundReturns,   ...     % effective fund returns for each period after all fees
    EffectiveAssetValue]    ...     % effective total asset values for each period after all fees
    = FeeCalculator_MultiPeriod(...
    FrondEndLoadRates,              ...
    BackEndLoadCDSCRates,           ...
    AnnualDistributionFeeRate,      ...
    AnnualManagementFeeRates,       ...
    MngFeeScaleLogic,               ...
    OtherAnnualServiceFeeRates,     ...
    OtherSubscriptionFeeRates,      ...
    OtherRedemptionFeeRates,        ...
    AssumedFundReturns,             ...
    SharePrice,                     ...     % gross subscription price
    NumShares,                      ...     % number of shares
    N)                                      % total number of periods (years)

% Fields in result matrix
ResultMatrixFields = {'FrondEndLoad', 'OtherSubsFees', 'AVafterSubsFees', ...
    'AssumedFundReturn','AVbeforeMngFees','EffMngFeeRate','ManagementFee', ...
    'AnnualDistrFee','AnnualServiceFee','AVbeforeRedempFee','BackEndLoadCDSC', ...
    'OtherRedempFee','AVAfterRedempFee'};

% initiate result matrices and vectors
ResultMatrix = zeros(N, 13);
EffectiveFundReturns = zeros(1,N);
EffectiveAssetValue = zeros(1,N);

% prepare all required input parameters for the single-period fee function
AssetVolume = SharePrice * NumShares; % initial asset volume

for CurrentPeriod = 1:N
    AssumedFundReturn = AssumedFundReturns(CurrentPeriod);
    
    % call single-period fee function
    ResultVector = FeeCalculator_SinglePeriod(...
    FrondEndLoadRates,              ...
    BackEndLoadCDSCRates,           ...
    AnnualDistributionFeeRate,      ...
    AnnualManagementFeeRates,       ...
    MngFeeScaleLogic,               ...
    OtherAnnualServiceFeeRates,     ...
    OtherSubscriptionFeeRates,      ...
    OtherRedemptionFeeRates,        ...
    AssumedFundReturn,              ...
    AssetVolume,                    ...
    NumShares,                      ...     % number of shares
    CurrentPeriod,                  ...
    N);      % total number of calculation periods
    
    % store results
    ResultMatrix(CurrentPeriod,:) = ResultVector;
    EffectiveAssetValue(CurrentPeriod) = ResultVector(end);
    EffectiveFundReturns(CurrentPeriod) = (EffectiveAssetValue(CurrentPeriod) - AssetVolume) /  AssetVolume * 100;
    AssetVolume = EffectiveAssetValue(CurrentPeriod); % asset volume as input for the next period
end     % for

